<?php
/* --------------------------------------------------------------
   CategoryPageNoIndexKeysDecorator.php 2025-09-11
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/
declare(strict_types=1);


namespace Gambio\Admin\Modules\SeoTags\Decorator;

class CategoryPageNoIndexKeysDecorator extends SeoTagsDataProviderDecorator
{
    
    /**
     * @var array<string, array<int, string>>
     */
    private array $noIndexKeysPerPageType;
    
    
    /**
     * @return array<string, array<int, string>>
     */
    public function getNoIndexKeysPerPageType(): array
    {
        $this->noIndexKeysPerPageType =  parent::getNoIndexKeysPerPageType();
        $pageType = 'page';
        $this->noIndexKeysPerPageType['category'][] = $pageType;
        
        return $this->noIndexKeysPerPageType;
    }
}